import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  // Configuration for GoDaddy deployment (disabled during admin development)
  // Enable static export so `next build` produces static HTML for upload to cPanel
  output: 'export',
  trailingSlash: true,
  skipTrailingSlashRedirect: true,
  distDir: 'dist',
  images: {
    unoptimized: true,
  },
  // Ensure paths work correctly on static hosting
  assetPrefix: process.env.NODE_ENV === 'production' ? '' : '',
  // Enable TypeScript checking during builds
  typescript: {
    ignoreBuildErrors: false,
  },
};

export default nextConfig;
